/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system.impl;

import com.pi4j.system.SystemInfo;
import com.pi4j.system.SystemInfoProvider;
import com.pi4j.system.impl.DefaultSystemInfoProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class NanoPiSystemInfoProvider
extends DefaultSystemInfoProvider
implements SystemInfoProvider {
    @Override
    public String getModelName() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("Processor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemInfo.BoardType getBoardType() throws IOException, InterruptedException, UnsupportedOperationException {
        SystemInfo.BoardType boardType = SystemInfo.BoardType.UNKNOWN;
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new FileReader("/etc/armbian-release"));
            while ((line = br.readLine()) != null) {
                String[] split;
                if (!line.contains("=") || !(split = line.split("="))[0].toLowerCase().trim().startsWith("board")) continue;
                switch (split[0].toLowerCase().trim()) {
                    case "nanopim1": {
                        boardType = SystemInfo.BoardType.NanoPi_M1;
                    }
                    case "nanopineo": {
                        boardType = SystemInfo.BoardType.NanoPi_NEO;
                    }
                    case "nanopiair": {
                        boardType = SystemInfo.BoardType.NanoPi_NEO_Air;
                    }
                }
                boardType = SystemInfo.BoardType.UNKNOWN;
            }
        }
        return boardType;
    }

    @Override
    public float getCpuTemperature() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        try (BufferedReader br = new BufferedReader(new FileReader("/sys/devices/virtual/thermal/thermal_zone0/temp"));){
            String line = br.readLine();
            if (line != null) {
                float f = Float.parseFloat(line);
                return f;
            }
        }
        throw new UnsupportedOperationException();
    }
}

