/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.nws.lub.rainpi2;

import gov.noaa.nws.lub.rainpi2.PrecipInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JSONStorage {
    private static final String mFilename = "pc.json";

    public static PrecipInfo load() {
        PrecipInfo pi = new PrecipInfo();
        File file = new File(mFilename);
        if (file.exists()) {
            JSONParser parser = new JSONParser();
            try {
                Object obj = parser.parse(new FileReader(mFilename));
                JSONObject jsonObject = (JSONObject)obj;
                System.out.println(jsonObject);
                pi.pc = (int)((Long)jsonObject.get("pc")).longValue();
                pi.latestEpoch = (Long)jsonObject.get("lastprecip");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return pi;
    }

    public static void save(PrecipInfo pc) {
        JSONObject obj = new JSONObject();
        obj.put("pc", pc.pc);
        obj.put("lastprecip", pc.latestEpoch);
        File file = new File(mFilename);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(obj.toJSONString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

