/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.nws.lub.rainpi2;

import gov.noaa.nws.lub.rainpi2.NetConfig;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;

public class Networking {
    public static ArrayList<NetConfig> getAddresses() {
        ArrayList<NetConfig> nc = new ArrayList<NetConfig>();
        try {
            Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
            while (eni.hasMoreElements()) {
                NetConfig nca = new NetConfig();
                NetworkInterface ni = eni.nextElement();
                byte[] mac = ni.getHardwareAddress();
                nca.SERIAL = Networking.macByteToString(mac);
                nca.name = ni.getDisplayName();
                ArrayList<String> ipa = new ArrayList<String>();
                Enumeration<InetAddress> ina = ni.getInetAddresses();
                while (ina.hasMoreElements()) {
                    InetAddress in = ina.nextElement();
                    ipa.add(in.getHostAddress());
                }
                nca.ipList = ipa;
                if (nca.SERIAL.length() <= 6) continue;
                nc.add(nca);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            System.err.println("SocketException exception");
        }
        return nc;
    }

    private static String macByteToString(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        if (mac != null) {
            int i = 0;
            while (i < mac.length) {
                String colon = "";
                colon = i < mac.length - 1 ? ":" : "";
                String macstr = String.format(Locale.US, "%02X%s", mac[i], colon);
                sb.append(macstr);
                ++i;
            }
            return sb.toString();
        }
        return "N/A";
    }
}

