/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.nws.lub.rainpi2;

import com.pi4j.system.SystemInfo;
import gov.noaa.nws.lub.rainpi2.Constants;
import gov.noaa.nws.lub.rainpi2.HardwareInterface;
import gov.noaa.nws.lub.rainpi2.JSONStorage;
import gov.noaa.nws.lub.rainpi2.NetConfig;
import gov.noaa.nws.lub.rainpi2.Networking;
import gov.noaa.nws.lub.rainpi2.OsUtils;
import gov.noaa.nws.lub.rainpi2.PrecipInfo;
import gov.noaa.nws.lub.rainpi2.ProcessUpdate;
import gov.noaa.nws.lub.rainpi2.URLConnectionReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TimingLoop
implements Runnable {
    long mNextReport = 0L;
    long mReportInterval = 300000L;
    boolean mStop;
    NetConfig mNetconf = new NetConfig();
    PrecipInfo pc = JSONStorage.load();
    private short mRestart = 1;

    public TimingLoop() {
        JSONStorage.save(this.pc);
        ArrayList<NetConfig> netconf = Networking.getAddresses();
        int i = 0;
        while (i < netconf.size()) {
            NetConfig nc = netconf.get(i);
            if (nc.name.equals("eth0") || nc.name.equals("enp2s0f0") || nc.name.equals("wlan0")) {
                this.mNetconf = nc;
                System.out.println("  Name: " + nc.name + " MAC: " + nc.SERIAL);
                int k = 0;
                while (k < nc.ipList.size()) {
                    System.out.println("    IP: " + nc.ipList.get(k));
                    ++k;
                }
            }
            ++i;
        }
        this.mNetconf.SERIAL = OsUtils.isWindows() ? this.getWinMboardSerial() : this.getRaspiSerial();
        if (this.mNetconf == null) {
            System.err.println("Suitable MAC address not found");
        } else {
            System.out.println("Using serial " + this.mNetconf.SERIAL);
        }
        this.triggerRegistration(System.currentTimeMillis());
        final TimingLoop tl = this;
        HardwareInterface hw = new HardwareInterface();
        hw.setOnHardwareClickListner(new HardwareInterface.OnHardwareClickListener(){

            @Override
            public void onTip() {
                tl.sendPrecipReport(1);
            }
        });
        hw.start();
        this.startRegistrationTimer(this);
        this.startSecondTimer(this);
    }

    private String getRaspiSerial() {
        System.out.println("Attempting to find Raspi Serial");
        String raspiSerial = null;
        try {
            raspiSerial = SystemInfo.getSerial();
        }
        catch (UnsupportedOperationException e) {
            raspiSerial = "No Serial UOE";
            e.printStackTrace();
        }
        catch (IOException e) {
            raspiSerial = "No Serial IOE";
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            raspiSerial = "No Serial INE";
            e.printStackTrace();
        }
        catch (Exception e) {
            raspiSerial = "No Serial UC";
            e.printStackTrace();
        }
        return "LIN-" + raspiSerial;
    }

    private String getWinMboardSerial() {
        System.out.println("Attempting to find Windows Serial");
        String result = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec("wmic baseboard get serialnumber");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
            if (result.equalsIgnoreCase(" ")) {
                System.out.println("Result is empty");
                result = null;
            }
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        result = result.replace("/", "").replace("nullSerialNumber", "").trim();
        return "WIN-" + result;
    }

    private void startRegistrationTimer(final TimingLoop tl) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                tl.triggerRegistration(System.currentTimeMillis());
            }
        }, 5000L, 300000L);
    }

    private void startSecondTimer(final TimingLoop tl) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){
            private boolean mFirstRun;

            @Override
            public void run() {
                if (!this.mFirstRun) {
                    tl.sendPrecipReport(0);
                    this.mFirstRun = true;
                }
                if (System.currentTimeMillis() / 1000L % 3600L == 0L) {
                    tl.sendPrecipReport(0);
                }
            }
        }, 15000L, 1000L);
    }

    private void startPrecipTriggerTimer(final TimingLoop tl) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                tl.sendPrecipReport(1);
            }
        }, 0L, 5000L);
    }

    protected void sendPrecipReport(int i) {
        System.out.println("Send PrecipReport " + i);
        this.pc = JSONStorage.load();
        this.pc.pc += i;
        this.pc.latestAmount = i;
        this.pc.latestEpoch = System.currentTimeMillis() / 1000L;
        JSONStorage.save(this.pc);
        URLConnectionReader ur = new URLConnectionReader();
        ur.setResponseListener(new URLConnectionReader.onResponseListener(){

            @Override
            public void response(String response) {
                System.out.println("Response..." + response);
            }
        });
        String post = String.format(Locale.US, "serial=%s&pc=%d&tip=%d&epoch=%d&restart=%d", this.mNetconf.SERIAL, this.pc.pc, this.pc.latestAmount, this.pc.latestEpoch, this.mRestart);
        ur.getText("http://" + Constants.mServerIp + ":" + Constants.mServerPort + "/regentag-io/rainpi-report.php", post);
        this.mRestart = 0;
    }

    private void triggerReport(long currentTimeMillis) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM YYYY HH:mm:ss");
        System.out.println("Trigger " + sdf.format(new Date(currentTimeMillis)));
    }

    private void triggerRegistration(long time) {
        System.out.println("Registering...");
        URLConnectionReader ur = new URLConnectionReader();
        ur.setResponseListener(new URLConnectionReader.onResponseListener(){

            @Override
            public void response(String response) {
                System.out.println("Response..." + response);
                JSONParser parser = new JSONParser();
                try {
                    Object obj = parser.parse(response.toString());
                    JSONObject jsonObject = (JSONObject)obj;
                    String id = (String)jsonObject.get("id");
                    int latest_version = (int)((Long)jsonObject.get("active_version")).longValue();
                    System.out.println(String.format("RainPIId = %s  Latest Available Version %d", id, latest_version));
                    if (Constants.mVersion != latest_version) {
                        new ProcessUpdate();
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
        });
        String post = String.format(Locale.US, "serial=%s&epoch=%d&pc=%d&version=%d", this.mNetconf.SERIAL, time, this.pc.pc, Constants.mVersion);
        ur.getText("http://" + Constants.mServerIp + ":" + Constants.mServerPort + "/regentag-io/rainpi-register.php", post);
    }

    @Override
    public void run() {
        this.mStop = false;
        while (!this.mStop) {
            if (System.currentTimeMillis() > this.mNextReport) {
                this.triggerReport(System.currentTimeMillis());
                this.mNextReport = System.currentTimeMillis() + this.mReportInterval;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

